/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.collections;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class WeightedCollection<E> {
    private final NavigableMap<Double, E> backingMap = new TreeMap<Double, E>();
    private double totalWeight = 0.0;

    public WeightedCollection() {
    }

    public WeightedCollection(Map<? extends E, Double> values) {
        values.forEach((k, v) -> this.add((double)v, (E)k));
    }

    public WeightedCollection<E> add(double weight, @Nonnull E result) {
        if (weight > 0.0) {
            this.totalWeight += weight;
            this.backingMap.put(this.totalWeight, result);
        }
        return this;
    }

    @Nonnull
    public E getRandomEntry(Random random) {
        double value = random.nextDouble() * this.totalWeight;
        return this.backingMap.higherEntry(value).getValue();
    }

    public Collection<E> values() {
        return this.backingMap.values();
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public void clear() {
        this.backingMap.clear();
    }
}

